/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class HLEUtilities {
    private static HLEUtilities instance;
    private int internalMemoryAddress;
    private int internalMemorySize;

    public static HLEUtilities getInstance() {
        if (instance == null) {
            instance = new HLEUtilities();
        }
        return instance;
    }

    private HLEUtilities() {
    }

    public void init() {
        this.internalMemoryAddress = 0;
        this.internalMemorySize = 0;
    }

    public int allocateInternalMemory(int size) {
        if (this.internalMemorySize < (size = Utilities.alignUp(size, 7))) {
            SysMemUserForUser.SysMemInfo sysMemInfo = Modules.SysMemUserForUserModule.malloc(1, "HLE Internal Memory", 0, Math.max(256, size), 0);
            this.internalMemoryAddress = sysMemInfo.addr;
            this.internalMemorySize = sysMemInfo.allocatedSize;
        }
        int addr = this.internalMemoryAddress;
        this.internalMemoryAddress += size;
        this.internalMemorySize -= size;
        return addr;
    }

    public static int NOP() {
        return 0;
    }

    public static int SYNC() {
        return 15;
    }

    public static int MOVE(int rd, int rs) {
        return 0x21 | rd << 11 | 0 | rs << 21;
    }

    public static int LUI(int rd, int imm16) {
        return 0x3C000000 | rd << 16 | imm16 & 0xFFFF;
    }

    public static int ADDIU(int rt, int rs, int imm16) {
        return 0x24000000 | rs << 21 | rt << 16 | imm16 & 0xFFFF;
    }

    public static int ORI(int rt, int rs, int imm16) {
        return 0x34000000 | rs << 21 | rt << 16 | imm16 & 0xFFFF;
    }

    public static int SW(int rt, int base, int imm16) {
        return 0xAC000000 | base << 21 | rt << 16 | imm16 & 0xFFFF;
    }

    public static int SB(int rt, int rs, int imm16) {
        return 0xA0000000 | rs << 21 | rt << 16 | imm16 & 0xFFFF;
    }

    public static int LW(int rt, int base, int imm16) {
        return 0x8C000000 | base << 21 | rt << 16 | imm16 & 0xFFFF;
    }

    public static int JAL(int address) {
        return 0xC000000 | address >> 2 & 0x3FFFFFF;
    }

    public static int J(int address) {
        return 0x8000000 | address >> 2 & 0x3FFFFFF;
    }

    public static int SYSCALL(int syscallCode) {
        return 0xC | syscallCode << 6;
    }

    public static int SYSCALL(HLEModule hleModule, String hleFunctionName) {
        HLEModuleFunction hleModuleFunction = hleModule.getHleFunctionByName(hleFunctionName);
        if (hleModuleFunction == null) {
            return HLEUtilities.SYSCALL(1048575);
        }
        return HLEUtilities.SYSCALL(hleModuleFunction.getSyscallCode());
    }

    public static int JR() {
        return HLEUtilities.JR(31);
    }

    public static int JR(int reg) {
        return 8 | reg << 21;
    }

    public static int B(int destination) {
        return 0x10000000 | destination & 0xFFFF;
    }

    public static int BREAK(int breakCode) {
        return 0xD | breakCode << 6;
    }

    public static int ERET() {
        return 1073741848;
    }

    public void installHLESyscall(int address, HLEModule hleModule, String hleFunctionName) {
        this.installHLESyscall(new TPointer(Memory.getInstance(), address), hleModule, hleFunctionName);
    }

    public void installHLESyscall(TPointer address, HLEModule hleModule, String hleFunctionName) {
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 8, 4);
        memoryWriter.writeNext(HLEUtilities.JR());
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.flush();
    }

    public void installHLESyscallWithJump(TPointer address, HLEModule hleModule, String hleFunctionName) {
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 16, 4);
        memoryWriter.writeNext(HLEUtilities.NOP());
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.writeNext(HLEUtilities.JR(2));
        memoryWriter.writeNext(HLEUtilities.NOP());
        memoryWriter.flush();
    }

    public int installHLESyscall(HLEModule hleModule, String hleFunctionName) {
        int addr = this.allocateInternalMemory(8);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, 8, 4);
        memoryWriter.writeNext(HLEUtilities.JR());
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.flush();
        return addr;
    }

    public int installLoopHandler(HLEModule hleModule, String hleFunctionName) {
        int address = this.allocateInternalMemory(8);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 8, 4);
        memoryWriter.writeNext(HLEUtilities.B(-1));
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.flush();
        return address;
    }

    public int installHLEThread(int address, HLEModule hleModule, String hleFunctionName) {
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 8, 4);
        memoryWriter.writeNext(HLEUtilities.B(-1));
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.flush();
        return address;
    }

    public int installHLEThread(HLEModule hleModule, String hleFunctionName) {
        return this.installHLEThread(this.allocateInternalMemory(8), hleModule, hleFunctionName);
    }

    public int installHLEInterruptHandler(HLEModule hleModule, String hleFunctionName) {
        int addr = this.allocateInternalMemory(16);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, 16, 4);
        memoryWriter.writeNext(HLEUtilities.NOP());
        memoryWriter.writeNext(HLEUtilities.SYSCALL(hleModule, hleFunctionName));
        memoryWriter.writeNext(HLEUtilities.ERET());
        memoryWriter.writeNext(HLEUtilities.NOP());
        memoryWriter.flush();
        return addr;
    }
}

